/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["/appcache.html","393f89736ecc6f11982181fcdec5a434"],["/assets/avatar/judoka-bubble.svg","53bc2a58411ab8f92da0a43b0f7829d6"],["/assets/avatar/judoka-face.svg","b47077b8faf1c85d666d8c028ba7c8c1"],["/assets/avatar/judoka-smile.svg","6230d8fe3077112271da71106b277dff"],["/assets/avatar/judoka.svg","c4ff3c1e4185a44cf8c716dc7416ba75"],["/assets/campaign/ks-button.svg","252580f8e98e5150494d94b56ef0c100"],["/assets/challenge-completed-star.svg","c68cdaedb67b5dca4aa74cd93777c469"],["/assets/get-share-link.svg","3d7c4b20b96830b2411e9a4464d4e494"],["/assets/icons/back.svg","f4f3b198c0dcf8f4ddde80e5c48119e0"],["/assets/icons/bin-icon.svg","64204672a53b313a3995a2d8388cc1ba"],["/assets/icons/bin.svg","7849fb0ed566b69f6d174600c0a4356a"],["/assets/icons/blockly-bin.svg","dfe7dad4a60aec05bbf69ab65c09ca7a"],["/assets/icons/blue-arrow.svg","3d387cec0d4308064c1832d7caf13051"],["/assets/icons/bucket.svg","8de4357efdf253415a74bfc6d1e07e2e"],["/assets/icons/exclamation.svg","643f80715dc59c3b6032dd215413b4a7"],["/assets/icons/export.svg","f3e1acbd4881cb8dfd42824c3ffc3163"],["/assets/icons/feedback.svg","4d5c90d779c90add90f043839ad598be"],["/assets/icons/fullscreen-icon.svg","0908d6bead3fafa1d2d8703aaa632e41"],["/assets/icons/help.svg","7e0923619b792e31b81c01dc97a1bebd"],["/assets/icons/import.svg","f62b48735d1f006ef08115e404b689fe"],["/assets/icons/judoka-face.svg","ca1446a85ce9c4078a1550f6c5348344"],["/assets/icons/levelup-radial.svg","53588cf74d3e91f8c4dcacc4b8689897"],["/assets/icons/lightning.svg","e1229ed4eabb3b2418d2d4d1d47fd023"],["/assets/icons/link-arrow.svg","ae7ecad29fb0b56cb92a2fdd9f8925a6"],["/assets/icons/logout.svg","bc968d6f3ca766f88e3ac14557ab387c"],["/assets/icons/modal-close-icon.svg","bb9547d520a7e92a7c64dc521848df2b"],["/assets/icons/new-level.svg","7053b6206f1c2c8d32602dfc5ee7876a"],["/assets/icons/parts/clock.svg","886090ade1d661a5f23dbc2eb1db4d46"],["/assets/icons/parts/hardware-speaker.svg","0c65459c24df19eec96ab6891c32148b"],["/assets/icons/parts/iss.svg","09e7b1ce77c203b99a33b4de63cbbe67"],["/assets/icons/parts/light-animation-display.svg","c0573d961301f8eda9a2e2ad7ef9ef0d"],["/assets/icons/parts/light-circle.svg","af92011f691f31c43485966fe7cfe223"],["/assets/icons/parts/light-rectangle.svg","b81e2c7044f74c66ee11b9d37e9c7ea9"],["/assets/icons/parts/microphone.svg","528763c441b61632effe2aeafae8f84c"],["/assets/icons/parts/oscillator.svg","04d652a22292bbce64cfcb9383b1b1ed"],["/assets/icons/parts/rss.svg","ab5e81f2202dd0960477cb08bf6944a3"],["/assets/icons/parts/shares.svg","ca0298476438a9d38b6f9159d3f7011c"],["/assets/icons/parts/sports.svg","b7b4c457f3cdfe135d88255d9fdcbdd0"],["/assets/icons/parts/weather.svg","e6c22fe9fd4b941770ca4f117f48e871"],["/assets/icons/pause-icon.svg","32c1d8c9b733faaa0481c5815a40de81"],["/assets/icons/pencil.svg","94f221c1a120578b58d831580266935a"],["/assets/icons/play-btn-overlay.svg","ae88ff995071a9d74bee8066e6e0319d"],["/assets/icons/refresh-icon.svg","df4307643366416d96b8bbea57a5be4d"],["/assets/icons/reset-icon.svg","22b2428efac25b7dc9f2374ea17f0a51"],["/assets/icons/reset.svg","d271518e9f20bd23267f14f391bcaf20"],["/assets/icons/save.svg","92c983ffafacdcd867d36c5e461a39ec"],["/assets/icons/settings-icon.svg","243720cc6083cfb3f27f96cccfcc131c"],["/assets/icons/success.svg","68d96afd9e2cf32ac37ce51707cede44"],["/assets/icons/target.svg","2cbe0c2385b88b1e7efa2618dbd6beff"],["/assets/icons/tick.svg","04f2057594d1fb8785e84330e77f443a"],["/assets/icons/white_arrow.svg","121241d31dd552bf6031089f58deac8c"],["/assets/icons/xp-star.svg","566e01b60f6aaea54fb364fc95144c25"],["/assets/icons/zoom-in.svg","cbeb024262e51667f06879a19ba4d7e9"],["/assets/icons/zoom-out.svg","c08e32a079cbc96beff20753658b936e"],["/assets/kano 2.svg","8549e2fb12629c6f73a22b8e0f7f6ace"],["/assets/kano 3.svg","8549e2fb12629c6f73a22b8e0f7f6ace"],["/assets/kano-code-logo.svg","6f6685660cf69608b01a28af46fcfc9c"],["/assets/kano-logo-simple.svg","381a86a43add18c5240e792e103a780a"],["/assets/kano-world-planet.svg","cf4d544a70572891abc5bb7f0435a9c8"],["/assets/kano.svg","8549e2fb12629c6f73a22b8e0f7f6ace"],["/assets/logo_beta.svg","71887fb2186137fedf23c0481b5ba143"],["/assets/make-apps-background.svg","d3d2748c5aa4c1953487957c3924cbbc"],["/assets/mode/lightboard/body-with-buttons.svg","57f185d1e0ca20ecd744591739d2211e"],["/assets/mode/lightboard/body.svg","b8ba1efb63eb45cd80876d7d7d41ffbc"],["/assets/mode/lightboard/led.svg","94728169327e2e4d13df0f569e9f8950"],["/assets/navbar/hamburger.svg","f829a6c0563459aa136731ad2657e378"],["/assets/navbar/kano.svg","8549e2fb12629c6f73a22b8e0f7f6ace"],["/assets/navbar/make-adventures.svg","67afd31676c602d56fbed1e5945a67e0"],["/assets/navbar/make-apps.svg","aa86b0d4bc607d63342abf31c69113e7"],["/assets/navbar/make-art.svg","fc057ecd74df97ec39b6fe13bfda0859"],["/assets/navbar/notification.svg","f78d2500ee1bcc64b1c085ced2b40a14"],["/assets/navbar/osapps.svg","a4b1d5250f4765082acc6556529d3aa5"],["/assets/part/accelerometer.svg","36fbf0256f541f51732a27030b20359f"],["/assets/part/box.svg","292dcac25bac9792844ca1b5e6b70390"],["/assets/part/button.svg","8019871c0ff192278c110790cca0358c"],["/assets/part/clock.svg","4b5529fb0acb31e54d061004e0a3db00"],["/assets/part/gesture.svg","521de602421a2a2e44a42b0ec1c36223"],["/assets/part/image.svg","29913d3aae1ff8f5bfe06cf76be89a64"],["/assets/part/iss.svg","586e0268ee84bfeda7adc841723a3fd9"],["/assets/part/kano-world.svg","be7e181487a4f898402fbe35d387c59f"],["/assets/part/keyboard.svg","f0dd60b52cb70ab758bd936519eac689"],["/assets/part/map-icon.svg","051e7d981831c4905846ba1a727f5f4f"],["/assets/part/map.svg","8ad3c81af2c81243909224b675d1bb24"],["/assets/part/microphone.svg","87d4821ff886008858f527811014d27b"],["/assets/part/motion-big.svg","87c6adfaf0f6fe141afd7b1da21d5f73"],["/assets/part/motion.svg","f89c556953918c36fcfb6e7a18804eff"],["/assets/part/mouse.svg","e96f63f8c9fb9799efb45c107eb95202"],["/assets/part/osc.svg","130638fc38c02d819855dad93f95f215"],["/assets/part/oscillator/sawtooth.svg","831f158b1a95907ab1e15915015793d8"],["/assets/part/oscillator/sine.svg","8c04d144ec2318b70cb73fff9c2d3416"],["/assets/part/oscillator/square.svg","f016c238975bd8ec5619a6a35dad41b7"],["/assets/part/oscillator/triangle.svg","24dbc2add2a361a40c6d1eb49522626e"],["/assets/part/piclist.svg","dab9c2c5c2a19b4bd677ae2fed7b63f1"],["/assets/part/picture-list-placeholder.svg","5a5c15152d4ddd8edac8e10c8f462c58"],["/assets/part/pixels-animation-play.svg","a4a91e55af84561512e000c31e907570"],["/assets/part/pixels-animation.svg","90a8d3016494a98301d4adb1e537bd33"],["/assets/part/pixels-circle.svg","99bc4e773168e38d0251ac7609134207"],["/assets/part/pixels-draw.svg","44c933e197668b94b2597803f28dcbf2"],["/assets/part/pixels-rectangle.svg","8cf9374a5528b83bea69a14f1a529fea"],["/assets/part/prism.svg","e0b5a846362b67cc18be03c452b0392c"],["/assets/part/proximity.svg","521de602421a2a2e44a42b0ec1c36223"],["/assets/part/rss.svg","909629066a5bba53097cff5e4c6ac98b"],["/assets/part/scrolling-text.svg","3129b11d00c751dfd1663dee10330145"],["/assets/part/slider.svg","b9e8846d365c6ad00d3991aa38f22752"],["/assets/part/speaker.svg","4d541a6da8eb33e604c18fff2437baae"],["/assets/part/sport.svg","9a7f4d41dcce33aadcd12f0ca8b3cd6b"],["/assets/part/sports.svg","a20c11bc276d18a708ba9f7fed964d67"],["/assets/part/stickers/animals/animal-bee.svg","e144c6c0a7a2434f662208bf5b89b798"],["/assets/part/stickers/animals/animal-bird.svg","24d7a095c59cf4ebf1a6646d2219aa75"],["/assets/part/stickers/animals/animal-blowfish.svg","16c75fad5f214242fcc7a76074bdc80d"],["/assets/part/stickers/animals/animal-bluehwhale.svg","1675e9676a9416f3689590c220a38c13"],["/assets/part/stickers/animals/animal-bunny.svg","7b4593dfab26a088a6483a2b6eacb0f7"],["/assets/part/stickers/animals/animal-camel.svg","a2fb1d552818beaefb7d4653da207cf0"],["/assets/part/stickers/animals/animal-cat.svg","92836e7b44819e4a8d6300a091734ae6"],["/assets/part/stickers/animals/animal-centipede.svg","d9142d48843740db6d3f3f5d2900a1da"],["/assets/part/stickers/animals/animal-chicken.svg","9b50f422b930f0815b1c349815fd5b52"],["/assets/part/stickers/animals/animal-clownfish.svg","6d51c298784d9f83dd9931ab7bedda9b"],["/assets/part/stickers/animals/animal-cow.svg","f59ccf11d2d1b53fb07996a1b2d2c7c2"],["/assets/part/stickers/animals/animal-crab.svg","aa41a897bc1bc175c41689b00b99e1ea"],["/assets/part/stickers/animals/animal-crocodile.svg","255ee7696b55ca3868d00eb4e52c922b"],["/assets/part/stickers/animals/animal-dog.svg","42e685d97abaf277971bf5673732fe2f"],["/assets/part/stickers/animals/animal-dolphin.svg","e7479bab4adffd1e04a83d8068929cdb"],["/assets/part/stickers/animals/animal-duck.svg","b055e46cbd47c1fd6185ec9adf020f56"],["/assets/part/stickers/animals/animal-elephant.svg","d92014fedb8b81baab6ed750ba590a7b"],["/assets/part/stickers/animals/animal-fish-1.svg","d18dfb118ca075e3ab7eed6ebc9f881c"],["/assets/part/stickers/animals/animal-goat.svg","b57b81cdf5618cbe809e3a425523a944"],["/assets/part/stickers/animals/animal-ladybug.svg","83c94a65a51a850f3d43aed9eb60e042"],["/assets/part/stickers/animals/animal-monkey.svg","d4949506db2f4be8f969489d4e392965"],["/assets/part/stickers/animals/animal-mouse-2.svg","2fe998aa3ba8e1024f36f4cafa6401a4"],["/assets/part/stickers/animals/animal-octopus.svg","d59493c473541bf5d036c56e996b152b"],["/assets/part/stickers/animals/animal-pig.svg","3dad82af3995eb17a59a2e6d7b7df7b0"],["/assets/part/stickers/animals/animal-poodle.svg","15c006d1e1f0418cbc60358da6512e62"],["/assets/part/stickers/animals/animal-sheep.svg","a38c4f69457767c7e362f32a20cfcd0e"],["/assets/part/stickers/animals/animal-shrimp.svg","4870ba8a52c50997f3594e544198cf6b"],["/assets/part/stickers/animals/animal-snail.svg","3c5dba13de93507262fea339d4e32550"],["/assets/part/stickers/animals/animal-snake.svg","b2b6a3c4ecc6af020a67a160ea8a8bb8"],["/assets/part/stickers/animals/animal-spider-2.svg","f7a680f59d1971d21f3b4564f625daee"],["/assets/part/stickers/animals/animal-spider.svg","58e11980fae4c72a9625a2f531bbc4e4"],["/assets/part/stickers/animals/animal-squirrel.svg","84b1d1707ea9de159b520a46e3f8a7c8"],["/assets/part/stickers/animals/animal-tiger.svg","7f5f4bf5c926e4998426a60d7c5ba29c"],["/assets/part/stickers/animals/animal-tortoise.svg","36cb5886ae3accf96c962ef823176596"],["/assets/part/stickers/animals/animal-unicorn.svg","bffd9a1668dbc714adda404b93489286"],["/assets/part/stickers/animals/animal-whale.svg","6a850d8ed7c8f8b3e63329a2c136ff41"],["/assets/part/stickers/food/food-burger.svg","51b6d54dc9ee98d8a063e25fbdfe5ccc"],["/assets/part/stickers/food/food-burrito.svg","6bf81ce7ef81aab8799951931e3fb230"],["/assets/part/stickers/food/food-candy.svg","60079f540fb0003a4845c37c484b1a57"],["/assets/part/stickers/food/food-cheese.svg","6697e53b3d3854090dd31a0b536855a7"],["/assets/part/stickers/food/food-cherry.svg","915b2cb979954471bfa8d9e732070317"],["/assets/part/stickers/food/food-chicken.svg","c7938fc97c7e6f107632bf3b9c166bcb"],["/assets/part/stickers/food/food-donut.svg","b859b58acbad8e1bca2ec29eb85ed944"],["/assets/part/stickers/food/food-eggplant.svg","3ca4db86e0f1199de1e26f756d52ec6f"],["/assets/part/stickers/food/food-icecream.svg","b86ad1a4ba70425e38f5297588051b9e"],["/assets/part/stickers/food/food-melon.svg","8e9437b57a72fff3ac9ec1f5ae8d5391"],["/assets/part/stickers/food/food-noodles.svg","92817bbaefc9b45d95e59c36b381cea5"],["/assets/part/stickers/food/food-peach.svg","a1cd8fc74e2847ddc4243cca9db0005b"],["/assets/part/stickers/food/food-pineapple.svg","58c72cd12bbfac9bd8f7fe280c7e806d"],["/assets/part/stickers/food/food-pizza.svg","ca1d86e0723bf884ca7601148bd45a9e"],["/assets/part/stickers/food/food-shrimp.svg","005204b744161fbbe85cb37459247ed9"],["/assets/part/stickers/food/food-sushi.svg","24c820d2c5ab79a2a36871b96b2f282e"],["/assets/part/stickers/food/food-taco.svg","e724ebe35afdf2e7056b8730b3b4247d"],["/assets/part/stickers/food/food-tomato.svg","5fc86a98abd131a8095b116e83cc1d4f"],["/assets/part/stickers/food/food-watermelon.svg","493c9bdf879da3027156bb46dae4d039"],["/assets/part/stickers/holidays/holidays-candle.svg","4db60b39ff4cb4209eec1d7c91252505"],["/assets/part/stickers/holidays/holidays-gift.svg","e3f7957551095baf6871202ce5819b93"],["/assets/part/stickers/holidays/holidays-gingerbread.svg","0bfb8ee56f3737f3c3411fe69d23067a"],["/assets/part/stickers/holidays/holidays-hat.svg","4b06616ea903ac50c6ede65ddf63d98e"],["/assets/part/stickers/holidays/holidays-tree.svg","3fe1639f436988bf9011c80c9252d054"],["/assets/part/stickers/kano/arrow.svg","eb2b571884703b1eaba05e3d1c1e4a05"],["/assets/part/stickers/kano/judoka-face.svg","ca1446a85ce9c4078a1550f6c5348344"],["/assets/part/stickers/kano/judoka-record.svg","800c5f5f261917db0d3919481345d439"],["/assets/part/stickers/kano/planet.svg","0fcaa250107d51f6aabee5eff34ee274"],["/assets/part/stickers/kano/robotnik.svg","22d9df2b84783126014b4b71a600eaff"],["/assets/part/stickers/kano/star.svg","48546bba8ba2715de030eb9618784ae9"],["/assets/part/stickers/masks/mask-alien.svg","d14aa021cbb0a5819ec78a29291dee83"],["/assets/part/stickers/masks/mask-bear.svg","6ab348e4b840f727d585c68cbc8dc074"],["/assets/part/stickers/masks/mask-blank.svg","0c447d7b6e88284741bb9a70f213a17b"],["/assets/part/stickers/masks/mask-boar.svg","f1a79f1fefd94725135248214e72b9a4"],["/assets/part/stickers/masks/mask-cat.svg","a860a4e9c04e5cc2c8c48ebf51f7ed46"],["/assets/part/stickers/masks/mask-chicken.svg","1b0f762c9c14b7dc308a80e9c456010a"],["/assets/part/stickers/masks/mask-cool.svg","368fd32b8f6ef6020e534efc6dc772f9"],["/assets/part/stickers/masks/mask-cow.svg","ee1d926e9c46e677e2242925f8911597"],["/assets/part/stickers/masks/mask-deer.svg","b5bf289a185eb901d2eda938e2320ffc"],["/assets/part/stickers/masks/mask-devil.svg","09cf1b8ac070f68b451de754e56f464a"],["/assets/part/stickers/masks/mask-dog.svg","d8225d4b952c1b5cc325e6e827da212a"],["/assets/part/stickers/masks/mask-easter-island.svg","d0e0c9b76514a1c6cb8b9b988b05d2e9"],["/assets/part/stickers/masks/mask-fox.svg","984ae0e09b54c95e13c22e34b925888f"],["/assets/part/stickers/masks/mask-frog.svg","2dc62d269672004b581d3e056151c938"],["/assets/part/stickers/masks/mask-gorilla.svg","de65a7626f89403e26eed5c12e05fddf"],["/assets/part/stickers/masks/mask-grin.svg","f9cd1d10220f7c5161d862ebdcda5717"],["/assets/part/stickers/masks/mask-horse.svg","06d0b7dd589fb7d872f7ccc8cf8b93bb"],["/assets/part/stickers/masks/mask-koala.svg","1b78123a5286af3af12ae91b105233b7"],["/assets/part/stickers/masks/mask-laughcry.svg","437e7b077de4e3ccd4bc42c60df48a08"],["/assets/part/stickers/masks/mask-lion.svg","4ed4f181c60639b9a97e17610393530d"],["/assets/part/stickers/masks/mask-meh.svg","079d2f4d08a9289a7289f798c86552f8"],["/assets/part/stickers/masks/mask-mokey.svg","93e586bb99dac8dfaf6e6555f8694181"],["/assets/part/stickers/masks/mask-mouse.svg","ffda2444921b69228291fa50745022c9"],["/assets/part/stickers/masks/mask-panda.svg","495e6dc58a86913df2477399e3e78838"],["/assets/part/stickers/masks/mask-pig.svg","1036416ac37e433260e450a69f98827c"],["/assets/part/stickers/masks/mask-pumpkin.svg","2dcce6668e085caf506bff23c5fdec59"],["/assets/part/stickers/masks/mask-rabbit.svg","84564edb3a34a7da402ae96da13baf58"],["/assets/part/stickers/masks/mask-robot.svg","37721a3154785c9557e97172b60c6ce7"],["/assets/part/stickers/masks/mask-rolleyes.svg","4c9cbd00e1e58d0d0cca2a4c2a4c48d0"],["/assets/part/stickers/masks/mask-santa.svg","aff86787a4ad7497ce8edd504caef1ea"],["/assets/part/stickers/masks/mask-skull.svg","ca5ca83f3d1c7d60dcdba18b97d68f7e"],["/assets/part/stickers/masks/mask-sleep.svg","32aa79d74f8fa22cca579c86dde847ea"],["/assets/part/stickers/masks/mask-small-mouse.svg","3a4038e1fe59ffac18a805c38e24d3ea"],["/assets/part/stickers/masks/mask-smile.svg","fdaec6a6be2207bd3436623a411d6778"],["/assets/part/stickers/masks/mask-tiger.svg","04d668ecca6d551b0f08a73029ca43c9"],["/assets/part/stickers/masks/mask-traditional.svg","1a97e9e64e832ccb6eab7ec1661dd09f"],["/assets/part/stickers/music/music-bell.svg","eb26be30e5b0e617e84f2665ffb79404"],["/assets/part/stickers/music/music-drum.svg","072de68f7012cd855f6281a9e1438c82"],["/assets/part/stickers/music/music-guitar.svg","b04f6915e15c402e7ea983b22b13b8e8"],["/assets/part/stickers/music/music-musical-note.svg","bc55faff7081e38b9300f2cb4afa13f3"],["/assets/part/stickers/music/music-musical-notes.svg","9385f5b0c3bd2064e47d8ce5964aad5a"],["/assets/part/stickers/music/music-pick.svg","956f7d0c5975515211bb5f77fc87cf7a"],["/assets/part/stickers/music/music-sax.svg","1a27b6ad5cf99afee8fd1e5131ad7aec"],["/assets/part/stickers/music/music-trumpet.svg","7f0a428e2ec84074019763ca8f4d3ef1"],["/assets/part/stickers/other/other-avocado.svg","56223cd60f7ec48e13e8a0db94dcc785"],["/assets/part/stickers/other/other-ball-baseball.svg","27209854bc98486318964e188f82f753"],["/assets/part/stickers/other/other-ball-basketball.svg","255312d1086d2531262c3c7a035f0fb8"],["/assets/part/stickers/other/other-ball-football.svg","c60aaf4dfcb496fd6ffd825b2587b2d5"],["/assets/part/stickers/other/other-ball-tennis.svg","2e6dbd914bcb249de840736a7e08187c"],["/assets/part/stickers/other/other-ball.svg","525d1096f42da4d5f3f0f240c6e94651"],["/assets/part/stickers/other/other-cactus.svg","030e6d2efc368f721295748885f468c4"],["/assets/part/stickers/other/other-cake.svg","03328e7c2b29d59f77baa85518999b4a"],["/assets/part/stickers/other/other-clap.svg","bdc4988f91bb09c3c0fb828d61f21ad8"],["/assets/part/stickers/other/other-clubs.svg","a3877db64ce54fd4b03319003bf990e8"],["/assets/part/stickers/other/other-controller.svg","536c2c45ade326ef4197eb48c75cff6a"],["/assets/part/stickers/other/other-diamonds.svg","445443b2957130ed4bd386dea6913625"],["/assets/part/stickers/other/other-dice.svg","607f2160bbfdeda0221f671cbaa0d8f3"],["/assets/part/stickers/other/other-eightball.svg","7c547d78c1b4698bdbe67fce6cc18c03"],["/assets/part/stickers/other/other-face.svg","eb3301ec88dae3fbc96c83bfe34dbdde"],["/assets/part/stickers/other/other-ghost.svg","52a1855c6542b674e2f145306c76bebe"],["/assets/part/stickers/other/other-hearts.svg","f1ef273a2c7c27cc82024e6f26bbf97d"],["/assets/part/stickers/other/other-hotdog.svg","fcbe1f291af38ea391307d7a69f05b7f"],["/assets/part/stickers/other/other-keyboard.svg","ca6c9d108150e02f00835b70d5e1c329"],["/assets/part/stickers/other/other-keytar.svg","30e559123396444f8a150f698a0af95f"],["/assets/part/stickers/other/other-lightning-bolt.svg","daa92de51b3a3c9825ea71a700823463"],["/assets/part/stickers/other/other-map.svg","7661ca808d3be4d7292d9fd97e3c9b06"],["/assets/part/stickers/other/other-medal-2.svg","520ae4acfffdaebc3b15af5dabd5173c"],["/assets/part/stickers/other/other-medal.svg","9ce76cd10d14d89247c296388ef14b1c"],["/assets/part/stickers/other/other-microphone.svg","269f6e131a6014360770f946afb002e9"],["/assets/part/stickers/other/other-micropscope.svg","f6a262ddcccdd48c4b4bca70fc67342e"],["/assets/part/stickers/other/other-minecraft-block.svg","f219585e0ec1aab7736afbde6465bd4b"],["/assets/part/stickers/other/other-paintbrush.svg","c724a14c256a992cdb5fa6e46cfc66f7"],["/assets/part/stickers/other/other-palm-tree.svg","e267c9682f3ebc0c94683311f5ba86c1"],["/assets/part/stickers/other/other-palmtree.svg","d21e2374c9506f629f776db310af07d4"],["/assets/part/stickers/other/other-pen.svg","a7e767d82b676777f8364b0fd2a164ea"],["/assets/part/stickers/other/other-piano-keyboard.svg","0a253bd3e20d97c2fd78f6df9e3423ea"],["/assets/part/stickers/other/other-poop.svg","ed14ed0a20d1be45463b818b4d1ea25e"],["/assets/part/stickers/other/other-popcorn.svg","0a093c2c2cbd9afd89ed5dc579db2a36"],["/assets/part/stickers/other/other-space-invader.svg","42696bf24081bd55a03e15d4e4cc084a"],["/assets/part/stickers/other/other-spades.svg","0913b86418ca9733d1bc86f856d44647"],["/assets/part/stickers/other/other-sprout.svg","339337a53aa68e890aafd0fc23b528d3"],["/assets/part/stickers/other/other-thermometer.svg","c5378fec22ac945da535a25e89322173"],["/assets/part/stickers/other/other-toadstool.svg","a14be676d662cda4d70be4b15fc0bbd8"],["/assets/part/stickers/other/other-trophy.svg","81852462a750c8929dde05a924ed0343"],["/assets/part/stickers/other/other-waffles.svg","6427eab8ed2ba33a8d4d6fb6fc1217a8"],["/assets/part/stickers/photo-play/photo-animal-nose.svg","b55bcafd9f7f3267d0b94e71e6eb69ca"],["/assets/part/stickers/photo-play/photo-boom.svg","ef756c6ecfdc1cf509cb0175dd33c76d"],["/assets/part/stickers/photo-play/photo-bubble-see-speech.svg","4a03a6605e65f9adb0684458cccd0963"],["/assets/part/stickers/photo-play/photo-bubble-speech-left.svg","e25af94cf4ac874559fe667aacd610e8"],["/assets/part/stickers/photo-play/photo-bubble-speech-right.svg","cf7f3e86b93c14f8e53feac55a1b637f"],["/assets/part/stickers/photo-play/photo-bubble-speech-urgent.svg","152ce02aa605fc4cda416f7c538eb2b0"],["/assets/part/stickers/photo-play/photo-bubble-thought.svg","2a73aad553d69de29634941e4bb68fb8"],["/assets/part/stickers/photo-play/photo-crown.svg","779fb0d7cf9afd16249ff8f82f0450e4"],["/assets/part/stickers/photo-play/photo-ears.svg","a6bc58ee59c6b95db9d0b0e90a3309ef"],["/assets/part/stickers/photo-play/photo-eye.svg","14a28558668a65318bd7812da7d443bf"],["/assets/part/stickers/photo-play/photo-eyes.svg","ccf4c733929efd9762ab02cd65175377"],["/assets/part/stickers/photo-play/photo-hearts.svg","70f567f2381c57bef68c7207047a11cf"],["/assets/part/stickers/photo-play/photo-lightbulb.svg","d05c13355ab94b98d3c8ba0367c9b8f8"],["/assets/part/stickers/photo-play/photo-lips.svg","0f7bf0aae65b06ec5a342ae10c4b1856"],["/assets/part/stickers/photo-play/photo-mouth.svg","1dc2d1d261117e88346765640e38eb47"],["/assets/part/stickers/photo-play/photo-nose.svg","95504d9ee568b1fb4e405cf6d547a76b"],["/assets/part/stickers/photo-play/photo-sunglasses.svg","257c0cd89a832bbec1dd24f4ce2551fb"],["/assets/part/stickers/photo-play/photo-tongue.svg","03ba06f6abbf1e4e44ee591037c18c6b"],["/assets/part/stickers/photo-play/photo-zzz.svg","ebd55fc1b90bc34d1bfb36b466b19d54"],["/assets/part/stickers/space/earth-america.svg","487af9f8669d2659ceb859f6dc7d2983"],["/assets/part/stickers/space/earth-asia.svg","92ac01847b2211edd71e887284fec8ff"],["/assets/part/stickers/space/earth-europe.svg","e40b15e51f4fa295d6576ef6aff1128f"],["/assets/part/stickers/space/meteor.svg","cfd4367196d227d2d84f94e62b9b9a8a"],["/assets/part/stickers/space/moon-1.svg","adff2251b7e3ebe10afd9a8a60247c66"],["/assets/part/stickers/space/moon-2.svg","47cf96971026fd3f1ec205928ca0a38a"],["/assets/part/stickers/space/moon-3.svg","ba707587014c62095171df32dea6e3ef"],["/assets/part/stickers/space/moon-4.svg","7426a0580d4a95133cd33630a2a784f7"],["/assets/part/stickers/space/moon-5.svg","37d1f79e28eb2f7c32e82b7dd3fa6f9c"],["/assets/part/stickers/space/moon-6.svg","c99a3d6a322cc9afbe91df4cfe308cbb"],["/assets/part/stickers/space/moon-7.svg","72366676f1a35daf460d3d93f80d88d5"],["/assets/part/stickers/space/moon-8.svg","94f92220e0771fe0a71fee2f64aa78ae"],["/assets/part/stickers/space/moon-smiling.svg","c1a0005ba1012d40010af3dcace883d4"],["/assets/part/stickers/space/night-sky.svg","62067ffe12d7e210c8c806d11ad16452"],["/assets/part/stickers/space/satellite.svg","8950ef013fdf4af550448d7f21df763a"],["/assets/part/stickers/space/space-rocket.svg","bc84b70369161737d127f8ed288dd43f"],["/assets/part/stickers/space/star.svg","ca307d2c1ce9be6de43db70f55839499"],["/assets/part/stickers/space/sun-smiling.svg","4fd22f2a340c7a2eaad9218c2521aebb"],["/assets/part/stickers/space/telescope.svg","d09a3ee01beceb01255e739e15c4c5f9"],["/assets/part/stickers/vehicles/ambulance.svg","5bfb1f479fd5b7c5bd662534abcd77db"],["/assets/part/stickers/vehicles/fire-engine.svg","9b478539dc650e8c6b690ab5e5b9f902"],["/assets/part/stickers/vehicles/police-car.svg","ff819634ae1a1b4b573b0110d683f7b1"],["/assets/part/stickers/vehicles/red-car.svg","e95285636dd8086f3b383f4291d32761"],["/assets/part/stickers/vehicles/taxi.svg","bee7a41823a58db69b17748a6319b62f"],["/assets/part/text-input.svg","341bda9afc00ed58a689a426f2971d1f"],["/assets/part/text.svg","e9735e6be84fb845cd14de9d174560b0"],["/assets/part/weather.svg","303d199c43ba6967bb71746a8572621b"],["/assets/part/webcam.svg","9f3d5be8087e1050d8621bd7a1bfde07"],["/assets/part/wiki.svg","e6d107246a3c030ada970646d4862d12"],["/assets/patterns/cross.svg","7bc9df5cadcdeaea840470bdc37a5c2e"],["/assets/stories/locales/en-US/background_color/background-color.svg","d5e8c13f33daf186ac1537a6268d7b00"],["/assets/stories/locales/en-US/draw_intro/background-color.svg","d5e8c13f33daf186ac1537a6268d7b00"],["/assets/stories/locales/en-US/space_tracker/iss.svg","20bc9e57a9e6b3871d61735f1c57d880"],["/assets/stories/locales/en-US/space_tracker/space-tracker.svg","723e5c111661dd5e9cde0d4b51cf7302"],["/assets/stories/locales/en-US/sports_round/sports-round.svg","5ebc696d368887b3db29ff0dbc2bf3be"],["/assets/stories/locales/en-US/weather/weather.svg","f2d54be6f5e69a28bcfb85e93c89441b"],["/assets/stories/locales/en-US/wind_direction/sports-round.svg","5ebc696d368887b3db29ff0dbc2bf3be"],["/assets/vendor/google-blockly/media/sprites.svg","911d25e52cb1d95f2d942ec5b7670d06"],["/elements/elements.html","98ee7467a27e1cb84a6510def927839b"],["/elements/elements.js","690c458db0a47b221394b0c635995676"],["/elements/kano-editor-camera/kano-editor-camera.html","9dbd8a6ebe9fc3de629e8f48c310e9e2"],["/elements/kano-editor-camera/kano-editor-camera.js","a16bb5c5808487c8faee28c644783992"],["/elements/kano-editor-lightboard/kano-editor-lightboard.html","46dfdb0d6c9c929c9c961b9a0f78ad18"],["/elements/kano-editor-lightboard/kano-editor-lightboard.js","664b66bf5b959a047dac9cbc9c336fcb"],["/elements/kano-editor-normal/kano-editor-normal.html","d8e2544f2ff8cfca770adeceb40e169c"],["/elements/kano-editor-normal/kano-editor-normal.js","42b2efd1cdf6bf4cbafa05afa82f78a3"],["/elements/kano-editor-simple/kano-editor-simple.html","540018ce5c1cbdd6d271eb3b9a70337f"],["/elements/kano-editor-simple/kano-editor-simple.js","4c9bd51bac9857b55c38fa96e2f1d0b2"],["/elements/msg/en-US.html","9249befff45ddc03550d84a953d1cba7"],["/elements/msg/es-AR.html","1b7fd04ff3f707082d77b586c0712756"],["/elements/msg/fr.html","a107838969dd8d518bf6fad6868cf405"],["/index.html","3b95fbc271cec22c8da5ac84a0e0e30a"],["/index.js","f5a0ce0fc4e86845fa10ac04fc7d4789"],["/manifest.json","19d245ae03cf52d7e83b72f710d69c3e"],["/scripts/index.js","075938f20da875053179e759eabd5bed"],["/scripts/kano-code-lib.js","83db51ce02f844a74cdf20332466fb18"],["/scripts/kano/gif-encoder/worker-neu.js","2db965c85c4f24089c145df05ff29dca"],["/scripts/kano/gif-encoder/worker-rgb.js","eaf80a800a3a6526068f8ff2c9f51491"],["/scripts/kano/make-apps/parts-api/canvas-filters.js","332a97140f38d2f619b22d97be6c45be"],["/scripts/splash.js","25be8c152175b743cc883378550d3a95"],["/views/kano-view-demo/kano-view-demo.html","eb47a07a387ee23a1324a85b6d1017b0"],["/views/kano-view-demo/kano-view-demo.js","97647b70a25fabdddaec65d3c4c21b79"],["/views/kano-view-editor/kano-view-editor.html","98b51e609443ea2a8b8be828f09498d7"],["/views/kano-view-editor/kano-view-editor.js","21367c249d1e9ac0c4232396bff4edc5"],["/views/kano-view-flags/kano-view-flags.html","39ba7a411f349a023a1519d504581514"],["/views/kano-view-flags/kano-view-flags.js","9d329b51e7faa990d2f271d41e95540e"],["/views/kano-view-onboarding/kano-view-onboarding.html","70eeb90a984e52cd7352756e9018088e"],["/views/kano-view-onboarding/kano-view-onboarding.js","4e77ab299d7ffedfc294ee72babd666b"],["/views/kano-view-story/kano-view-story.html","e8e52dc96efbe4b36add4d638c0c0038"],["/views/kano-view-story/kano-view-story.js","b565dfce2698893bc2a68423c06e8588"],["/views/kano-view-tutorial/kano-view-tutorial.html","3c94f1a73be2b619b2570f1f51f5c7d7"],["/views/kano-view-tutorial/kano-view-tutorial.js","d216d425e573811d90a92e2fe1b97a8a"]];
var cacheName = 'sw-precache-v2-make-apps-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {
                credentials: 'same-origin',
                redirect: 'follow'
              }));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '/index.html';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});


// *** Start of auto-included sw-toolbox code. ***
/* 
 Copyright 2016 Google Inc. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var t;t="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,t.toolbox=e()}}(function(){return function e(t,n,r){function o(c,s){if(!n[c]){if(!t[c]){var a="function"==typeof require&&require;if(!s&&a)return a(c,!0);if(i)return i(c,!0);var u=new Error("Cannot find module '"+c+"'");throw u.code="MODULE_NOT_FOUND",u}var f=n[c]={exports:{}};t[c][0].call(f.exports,function(e){var n=t[c][1][e];return o(n?n:e)},f,f.exports,e,t,n,r)}return n[c].exports}for(var i="function"==typeof require&&require,c=0;c<r.length;c++)o(r[c]);return o}({1:[function(e,t,n){"use strict";function r(e,t){t=t||{};var n=t.debug||m.debug;n&&console.log("[sw-toolbox] "+e)}function o(e){var t;return e&&e.cache&&(t=e.cache.name),t=t||m.cache.name,caches.open(t)}function i(e,t){t=t||{};var n=t.successResponses||m.successResponses;return fetch(e.clone()).then(function(r){return"GET"===e.method&&n.test(r.status)&&o(t).then(function(n){n.put(e,r).then(function(){var r=t.cache||m.cache;(r.maxEntries||r.maxAgeSeconds)&&r.name&&c(e,n,r)})}),r.clone()})}function c(e,t,n){var r=s.bind(null,e,t,n);d=d?d.then(r):r()}function s(e,t,n){var o=e.url,i=n.maxAgeSeconds,c=n.maxEntries,s=n.name,a=Date.now();return r("Updating LRU order for "+o+". Max entries is "+c+", max age is "+i),g.getDb(s).then(function(e){return g.setTimestampForUrl(e,o,a)}).then(function(e){return g.expireEntries(e,c,i,a)}).then(function(e){r("Successfully updated IDB.");var n=e.map(function(e){return t.delete(e)});return Promise.all(n).then(function(){r("Done with cache cleanup.")})}).catch(function(e){r(e)})}function a(e,t,n){return r("Renaming cache: ["+e+"] to ["+t+"]",n),caches.delete(t).then(function(){return Promise.all([caches.open(e),caches.open(t)]).then(function(t){var n=t[0],r=t[1];return n.keys().then(function(e){return Promise.all(e.map(function(e){return n.match(e).then(function(t){return r.put(e,t)})}))}).then(function(){return caches.delete(e)})})})}function u(e,t){return o(t).then(function(t){return t.add(e)})}function f(e,t){return o(t).then(function(t){return t.delete(e)})}function h(e){e instanceof Promise||p(e),m.preCacheItems=m.preCacheItems.concat(e)}function p(e){var t=Array.isArray(e);if(t&&e.forEach(function(e){"string"==typeof e||e instanceof Request||(t=!1)}),!t)throw new TypeError("The precache method expects either an array of strings and/or Requests or a Promise that resolves to an array of strings and/or Requests.");return e}function l(e,t,n){if(!e)return!1;if(t){var r=e.headers.get("date");if(r){var o=new Date(r);if(o.getTime()+1e3*t<n)return!1}}return!0}var d,m=e("./options"),g=e("./idb-cache-expiration");t.exports={debug:r,fetchAndCache:i,openCache:o,renameCache:a,cache:u,uncache:f,precache:h,validatePrecacheInput:p,isResponseFresh:l}},{"./idb-cache-expiration":2,"./options":4}],2:[function(e,t,n){"use strict";function r(e){return new Promise(function(t,n){var r=indexedDB.open(u+e,f);r.onupgradeneeded=function(){var e=r.result.createObjectStore(h,{keyPath:p});e.createIndex(l,l,{unique:!1})},r.onsuccess=function(){t(r.result)},r.onerror=function(){n(r.error)}})}function o(e){return e in d||(d[e]=r(e)),d[e]}function i(e,t,n){return new Promise(function(r,o){var i=e.transaction(h,"readwrite"),c=i.objectStore(h);c.put({url:t,timestamp:n}),i.oncomplete=function(){r(e)},i.onabort=function(){o(i.error)}})}function c(e,t,n){return t?new Promise(function(r,o){var i=1e3*t,c=[],s=e.transaction(h,"readwrite"),a=s.objectStore(h),u=a.index(l);u.openCursor().onsuccess=function(e){var t=e.target.result;if(t&&n-i>t.value[l]){var r=t.value[p];c.push(r),a.delete(r),t.continue()}},s.oncomplete=function(){r(c)},s.onabort=o}):Promise.resolve([])}function s(e,t){return t?new Promise(function(n,r){var o=[],i=e.transaction(h,"readwrite"),c=i.objectStore(h),s=c.index(l),a=s.count();s.count().onsuccess=function(){var e=a.result;e>t&&(s.openCursor().onsuccess=function(n){var r=n.target.result;if(r){var i=r.value[p];o.push(i),c.delete(i),e-o.length>t&&r.continue()}})},i.oncomplete=function(){n(o)},i.onabort=r}):Promise.resolve([])}function a(e,t,n,r){return c(e,n,r).then(function(n){return s(e,t).then(function(e){return n.concat(e)})})}var u="sw-toolbox-",f=1,h="store",p="url",l="timestamp",d={};t.exports={getDb:o,setTimestampForUrl:i,expireEntries:a}},{}],3:[function(e,t,n){"use strict";function r(e){var t=a.match(e.request);t?e.respondWith(t(e.request)):a.default&&"GET"===e.request.method&&0===e.request.url.indexOf("http")&&e.respondWith(a.default(e.request))}function o(e){s.debug("activate event fired");var t=u.cache.name+"$$$inactive$$$";e.waitUntil(s.renameCache(t,u.cache.name))}function i(e){return e.reduce(function(e,t){return e.concat(t)},[])}function c(e){var t=u.cache.name+"$$$inactive$$$";s.debug("install event fired"),s.debug("creating cache ["+t+"]"),e.waitUntil(s.openCache({cache:{name:t}}).then(function(e){return Promise.all(u.preCacheItems).then(i).then(s.validatePrecacheInput).then(function(t){return s.debug("preCache list: "+(t.join(", ")||"(none)")),e.addAll(t)})}))}e("serviceworker-cache-polyfill");var s=e("./helpers"),a=e("./router"),u=e("./options");t.exports={fetchListener:r,activateListener:o,installListener:c}},{"./helpers":1,"./options":4,"./router":6,"serviceworker-cache-polyfill":16}],4:[function(e,t,n){"use strict";var r;r=self.registration?self.registration.scope:self.scope||new URL("./",self.location).href,t.exports={cache:{name:"$$$toolbox-cache$$$"+r+"$$$",maxAgeSeconds:null,maxEntries:null},debug:!1,networkTimeoutSeconds:null,preCacheItems:[],successResponses:/^0|([123]\d\d)|(40[14567])|410$/}},{}],5:[function(e,t,n){"use strict";var r=new URL("./",self.location),o=r.pathname,i=e("path-to-regexp"),c=function(e,t,n,r){t instanceof RegExp?this.fullUrlRegExp=t:(0!==t.indexOf("/")&&(t=o+t),this.keys=[],this.regexp=i(t,this.keys)),this.method=e,this.options=r,this.handler=n};c.prototype.makeHandler=function(e){var t;if(this.regexp){var n=this.regexp.exec(e);t={},this.keys.forEach(function(e,r){t[e.name]=n[r+1]})}return function(e){return this.handler(e,t,this.options)}.bind(this)},t.exports=c},{"path-to-regexp":15}],6:[function(e,t,n){"use strict";function r(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}var o=e("./route"),i=e("./helpers"),c=function(e,t){for(var n=e.entries(),r=n.next(),o=[];!r.done;){var i=new RegExp(r.value[0]);i.test(t)&&o.push(r.value[1]),r=n.next()}return o},s=function(){this.routes=new Map,this.routes.set(RegExp,new Map),this.default=null};["get","post","put","delete","head","any"].forEach(function(e){s.prototype[e]=function(t,n,r){return this.add(e,t,n,r)}}),s.prototype.add=function(e,t,n,c){c=c||{};var s;t instanceof RegExp?s=RegExp:(s=c.origin||self.location.origin,s=s instanceof RegExp?s.source:r(s)),e=e.toLowerCase();var a=new o(e,t,n,c);this.routes.has(s)||this.routes.set(s,new Map);var u=this.routes.get(s);u.has(e)||u.set(e,new Map);var f=u.get(e),h=a.regexp||a.fullUrlRegExp;f.has(h.source)&&i.debug('"'+t+'" resolves to same regex as existing route.'),f.set(h.source,a)},s.prototype.matchMethod=function(e,t){var n=new URL(t),r=n.origin,o=n.pathname;return this._match(e,c(this.routes,r),o)||this._match(e,[this.routes.get(RegExp)],t)},s.prototype._match=function(e,t,n){if(0===t.length)return null;for(var r=0;r<t.length;r++){var o=t[r],i=o&&o.get(e.toLowerCase());if(i){var s=c(i,n);if(s.length>0)return s[0].makeHandler(n)}}return null},s.prototype.match=function(e){return this.matchMethod(e.method,e.url)||this.matchMethod("any",e.url)},t.exports=new s},{"./helpers":1,"./route":5}],7:[function(e,t,n){"use strict";function r(e,t,n){return n=n||{},i.debug("Strategy: cache first ["+e.url+"]",n),i.openCache(n).then(function(t){return t.match(e).then(function(t){var r=n.cache||o.cache,c=Date.now();return i.isResponseFresh(t,r.maxAgeSeconds,c)?t:i.fetchAndCache(e,n)})})}var o=e("../options"),i=e("../helpers");t.exports=r},{"../helpers":1,"../options":4}],8:[function(e,t,n){"use strict";function r(e,t,n){return n=n||{},i.debug("Strategy: cache only ["+e.url+"]",n),i.openCache(n).then(function(t){return t.match(e).then(function(e){var t=n.cache||o.cache,r=Date.now();if(i.isResponseFresh(e,t.maxAgeSeconds,r))return e})})}var o=e("../options"),i=e("../helpers");t.exports=r},{"../helpers":1,"../options":4}],9:[function(e,t,n){"use strict";function r(e,t,n){return o.debug("Strategy: fastest ["+e.url+"]",n),new Promise(function(r,c){var s=!1,a=[],u=function(e){a.push(e.toString()),s?c(new Error('Both cache and network failed: "'+a.join('", "')+'"')):s=!0},f=function(e){e instanceof Response?r(e):u("No result returned")};o.fetchAndCache(e.clone(),n).then(f,u),i(e,t,n).then(f,u)})}var o=e("../helpers"),i=e("./cacheOnly");t.exports=r},{"../helpers":1,"./cacheOnly":8}],10:[function(e,t,n){t.exports={networkOnly:e("./networkOnly"),networkFirst:e("./networkFirst"),cacheOnly:e("./cacheOnly"),cacheFirst:e("./cacheFirst"),fastest:e("./fastest")}},{"./cacheFirst":7,"./cacheOnly":8,"./fastest":9,"./networkFirst":11,"./networkOnly":12}],11:[function(e,t,n){"use strict";function r(e,t,n){n=n||{};var r=n.successResponses||o.successResponses,c=n.networkTimeoutSeconds||o.networkTimeoutSeconds;return i.debug("Strategy: network first ["+e.url+"]",n),i.openCache(n).then(function(t){var s,a,u=[];if(c){var f=new Promise(function(r){s=setTimeout(function(){t.match(e).then(function(e){var t=n.cache||o.cache,c=Date.now(),s=t.maxAgeSeconds;i.isResponseFresh(e,s,c)&&r(e)})},1e3*c)});u.push(f)}var h=i.fetchAndCache(e,n).then(function(e){if(s&&clearTimeout(s),r.test(e.status))return e;throw i.debug("Response was an HTTP error: "+e.statusText,n),a=e,new Error("Bad response")}).catch(function(r){return i.debug("Network or response error, fallback to cache ["+e.url+"]",n),t.match(e).then(function(e){if(e)return e;if(a)return a;throw r})});return u.push(h),Promise.race(u)})}var o=e("../options"),i=e("../helpers");t.exports=r},{"../helpers":1,"../options":4}],12:[function(e,t,n){"use strict";function r(e,t,n){return o.debug("Strategy: network only ["+e.url+"]",n),fetch(e)}var o=e("../helpers");t.exports=r},{"../helpers":1}],13:[function(e,t,n){"use strict";var r=e("./options"),o=e("./router"),i=e("./helpers"),c=e("./strategies"),s=e("./listeners");i.debug("Service Worker Toolbox is loading"),self.addEventListener("install",s.installListener),self.addEventListener("activate",s.activateListener),self.addEventListener("fetch",s.fetchListener),t.exports={networkOnly:c.networkOnly,networkFirst:c.networkFirst,cacheOnly:c.cacheOnly,cacheFirst:c.cacheFirst,fastest:c.fastest,router:o,options:r,cache:i.cache,uncache:i.uncache,precache:i.precache}},{"./helpers":1,"./listeners":3,"./options":4,"./router":6,"./strategies":10}],14:[function(e,t,n){t.exports=Array.isArray||function(e){return"[object Array]"==Object.prototype.toString.call(e)}},{}],15:[function(e,t,n){function r(e,t){for(var n,r=[],o=0,i=0,c="",s=t&&t.delimiter||"/";null!=(n=x.exec(e));){var f=n[0],h=n[1],p=n.index;if(c+=e.slice(i,p),i=p+f.length,h)c+=h[1];else{var l=e[i],d=n[2],m=n[3],g=n[4],v=n[5],w=n[6],y=n[7];c&&(r.push(c),c="");var b=null!=d&&null!=l&&l!==d,E="+"===w||"*"===w,R="?"===w||"*"===w,k=n[2]||s,$=g||v;r.push({name:m||o++,prefix:d||"",delimiter:k,optional:R,repeat:E,partial:b,asterisk:!!y,pattern:$?u($):y?".*":"[^"+a(k)+"]+?"})}}return i<e.length&&(c+=e.substr(i)),c&&r.push(c),r}function o(e,t){return s(r(e,t))}function i(e){return encodeURI(e).replace(/[\/?#]/g,function(e){return"%"+e.charCodeAt(0).toString(16).toUpperCase()})}function c(e){return encodeURI(e).replace(/[?#]/g,function(e){return"%"+e.charCodeAt(0).toString(16).toUpperCase()})}function s(e){for(var t=new Array(e.length),n=0;n<e.length;n++)"object"==typeof e[n]&&(t[n]=new RegExp("^(?:"+e[n].pattern+")$"));return function(n,r){for(var o="",s=n||{},a=r||{},u=a.pretty?i:encodeURIComponent,f=0;f<e.length;f++){var h=e[f];if("string"!=typeof h){var p,l=s[h.name];if(null==l){if(h.optional){h.partial&&(o+=h.prefix);continue}throw new TypeError('Expected "'+h.name+'" to be defined')}if(v(l)){if(!h.repeat)throw new TypeError('Expected "'+h.name+'" to not repeat, but received `'+JSON.stringify(l)+"`");if(0===l.length){if(h.optional)continue;throw new TypeError('Expected "'+h.name+'" to not be empty')}for(var d=0;d<l.length;d++){if(p=u(l[d]),!t[f].test(p))throw new TypeError('Expected all "'+h.name+'" to match "'+h.pattern+'", but received `'+JSON.stringify(p)+"`");o+=(0===d?h.prefix:h.delimiter)+p}}else{if(p=h.asterisk?c(l):u(l),!t[f].test(p))throw new TypeError('Expected "'+h.name+'" to match "'+h.pattern+'", but received "'+p+'"');o+=h.prefix+p}}else o+=h}return o}}function a(e){return e.replace(/([.+*?=^!:${}()[\]|\/\\])/g,"\\$1")}function u(e){return e.replace(/([=!:$\/()])/g,"\\$1")}function f(e,t){return e.keys=t,e}function h(e){return e.sensitive?"":"i"}function p(e,t){var n=e.source.match(/\((?!\?)/g);if(n)for(var r=0;r<n.length;r++)t.push({name:r,prefix:null,delimiter:null,optional:!1,repeat:!1,partial:!1,asterisk:!1,pattern:null});return f(e,t)}function l(e,t,n){for(var r=[],o=0;o<e.length;o++)r.push(g(e[o],t,n).source);var i=new RegExp("(?:"+r.join("|")+")",h(n));return f(i,t)}function d(e,t,n){return m(r(e,n),t,n)}function m(e,t,n){v(t)||(n=t||n,t=[]),n=n||{};for(var r=n.strict,o=n.end!==!1,i="",c=0;c<e.length;c++){var s=e[c];if("string"==typeof s)i+=a(s);else{var u=a(s.prefix),p="(?:"+s.pattern+")";t.push(s),s.repeat&&(p+="(?:"+u+p+")*"),p=s.optional?s.partial?u+"("+p+")?":"(?:"+u+"("+p+"))?":u+"("+p+")",i+=p}}var l=a(n.delimiter||"/"),d=i.slice(-l.length)===l;return r||(i=(d?i.slice(0,-l.length):i)+"(?:"+l+"(?=$))?"),i+=o?"$":r&&d?"":"(?="+l+"|$)",f(new RegExp("^"+i,h(n)),t)}function g(e,t,n){return v(t)||(n=t||n,t=[]),n=n||{},e instanceof RegExp?p(e,t):v(e)?l(e,t,n):d(e,t,n)}var v=e("isarray");t.exports=g,t.exports.parse=r,t.exports.compile=o,t.exports.tokensToFunction=s,t.exports.tokensToRegExp=m;var x=new RegExp(["(\\\\.)","([\\/.])?(?:(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?|(\\*))"].join("|"),"g")},{isarray:14}],16:[function(e,t,n){!function(){var e=Cache.prototype.addAll,t=navigator.userAgent.match(/(Firefox|Chrome)\/(\d+\.)/);if(t)var n=t[1],r=parseInt(t[2]);e&&(!t||"Firefox"===n&&r>=46||"Chrome"===n&&r>=50)||(Cache.prototype.addAll=function(e){function t(e){this.name="NetworkError",this.code=19,this.message=e}var n=this;return t.prototype=Object.create(Error.prototype),Promise.resolve().then(function(){if(arguments.length<1)throw new TypeError;return e=e.map(function(e){return e instanceof Request?e:String(e)}),Promise.all(e.map(function(e){"string"==typeof e&&(e=new Request(e));var n=new URL(e.url).protocol;if("http:"!==n&&"https:"!==n)throw new t("Invalid scheme");return fetch(e.clone())}))}).then(function(r){if(r.some(function(e){return!e.ok}))throw new t("Incorrect response status");return Promise.all(r.map(function(t,r){return n.put(e[r],t)}))}).then(function(){})},Cache.prototype.add=function(e){return this.addAll([e])})}()},{}]},{},[13])(13)});


// *** End of auto-included sw-toolbox code. ***



// Runtime cache configuration, using the sw-toolbox library.

toolbox.router.get(/^https:\/\/fonts\.googleapis\.com\/css/, toolbox.cacheFirst, {});
toolbox.router.get(/assets/, toolbox.cacheFirst, {});
toolbox.router.get(/bower_components/, toolbox.cacheFirst, {});




